<?php
    
    namespace Source\Support;
    
    use Exception;
    use stdClass;
    use PHPMailer\PHPMailer\PHPMailer;
    
    class Email
    {
        /** @var PHPMailer */
        private $mail;
        
        /** @var stdClass */
        private $data;
        
        /** @var Exception */
        private $error;
        
        public function __construct()
        {
            $this->mail = new PHPMailer();
            $this->data = new stdClass();
            
            $this->mail->isSMTP();
            $this->mail->isHTML();
            $this->mail->setLanguage('br');
            
            $this->mail->SMTPAuth = true;
            $this->mail->SMTPSecure = MAIL_SMTP['secure'];
            $this->mail->CharSet = "utf-8";
            
            $this->mail->Host = MAIL_SMTP['host'];
            $this->mail->Port = MAIL_SMTP['port'];
            $this->mail->Username = MAIL_SMTP['user'];
            $this->mail->Password = MAIL_SMTP['pass'];
        }
        
        public function add(string $subject, string $body, string $recipient_name, string $recipient_email): Email
        {
            $this->data->subject = $subject;
            $this->data->body = $body;
            $this->data->recipient_name = $recipient_name;
            $this->data->recipient_email = $recipient_email;
            return $this;
        }
        
        public function attach(string $filePath, string $fileName): Email
        {
            $this->data->attach[$filePath] = $fileName;
            return $this;
        }
        
        public function send(string $from_name = null, string $from_email = null): bool
        {
            $fromName = (empty($from_name) ? MAIL_SMTP['from_name'] : $from_name);
            $fromEmail = (empty($from_email) ? MAIL_SMTP['from_email'] : $from_email);
            $this->data->body = "<div style='max-width: 620px; padding: 15px; overflow: auto;'>{$this->data->body}<hr><small>Recebida em: " . date('d/m/Y H:i') . "</small></div>";
            
            try {
                $this->mail->Subject = $this->data->subject;
                $this->mail->msgHTML($this->data->body);
                $this->mail->addAddress($this->data->recipient_email, $this->data->recipient_name);
                $this->mail->setFrom($fromEmail, $fromName);
                
                if (!empty($this->data->attach)):
                    foreach ($this->data->attach as $path => $name):
                        $this->mail->addAttachment($path, $name);
                    endforeach;
                endif;
                
                $this->mail->send();
                return true;
            }
            catch (Exception $exception) {
                $this->error = $exception;
                return false;
            }
        }
        
        public function error(): ?Exception
        {
            return $this->error;
        }
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    