<?php

use Source\Support\Helper;
use CoffeeCode\Cropper\Cropper;

$c = new Cropper("cache");

$v->layout('inc/layout');
?>

<section class="container padding-high bg-silver">
    <div class="content">
        <div class="box80" style="margin: 0 auto;">
            <header class="header-post">
                <h1 class="f-black f-semibold title-page mb-40"><?= $post->title ?></h1>
                <div class="post-details flex-container">
                    <p class="bg-white radius-g f-black t-upper mr-10"><i class="icon-arrow-right2 f-blue"></i> <?= getTypePost($post->type) ?></p>
                    <p class="bg-white radius-g f-black t-upper mr-10"><i class="icon-arrow-right2 f-blue"></i> <?= $post->getCategory()->title ?></p>
                    <p class="bg-white radius-g f-black t-upper"><i class="icon-clock1 f-blue"></i> <?= date('d/m/Y H:i', strtotime($post->created_at)) ?>h</p>
                </div>
            </header>
        </div>
        <div class="mb-40"></div>
        <div class="box80" style="margin: 0 auto;">
            <div class="post-description">
                <div class="post-photo" style="height: auto; width: 75%; margin: 0 auto;">
                    <?= Helper::image($c->make($post->cover, 1000, 650), $post->title, "img") ?>
                </div>
                <div class="post-text padding-total-normal bg-white"><?= $post->description ?></div>
            </div>
        </div>
        <aside class="post-sidebar box80 mt-40">
            <?php if ($gallery) : ?>
                <div class="content-gallery mb-50">
                    <h2 class="title-page-sec f-black f-semibold mb-20"><i class="fa fa-photo"></i> Galeria de imagens</h2>
                    <div class="flex-container flex-wrap content-gallery">
                        <?php foreach ($gallery as $gb) : ?>
                            <article class="flex flex25">
                                <a href="<?= HOME . '/' . $gb->cover ?>" rel="shadowbox[album]">
                                    <?= Helper::image($c->make($gb->cover, 1000, 650), $post->title, "img") ?>
                                </a>
                            </article>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endif; ?>

            <div>
                <h2 class="title-page-sec f-black f-semibold mb-40">Outros Posts</h2>
                <div class="content-other-news second flex-container flex-wrap">
                    <?php foreach ($posts as $pt) : ?>
                        <a href="<?= HOME ?>/noticias/<?= $pt->uri ?>" class="flex flex33">
                            <article class="wall flex-container flex-direction-column flex-justify-end" style="background-image: url(<?= HOME . '/' . $pt->cover ?>);">
                                <header class="shadow-title transition">
                                    <h1 class="f-semibold f-white transition"><?= $pt->title ?></h1>
                                </header>
                            </article>
                        </a>
                    <?php endforeach; ?>
                </div>
            </div>
        </aside>
    </div>
</section>