<?php

namespace Source\App\Web;

use League\Plates\Engine;
use CoffeeCode\Optimizer\Optimizer;
use Source\Models\GbPost;
use Source\Models\Post;
use CoffeeCode\Paginator\Paginator;

class News
{
    private $template;
    private $optimizer;

    public function __construct($router)
    {
        $this->template = Engine::create(THEME, FILE_EXT);
        $this->optimizer = new Optimizer();

        $this->template->addData([
            "router" => $router
        ]);
    }

    public function index()
    {
        $page = filter_input(INPUT_GET, "page", FILTER_VALIDATE_INT);
        $post = new Post();
        /*
             * PAGINATOR
             */
        $paginator = new Paginator(HOME . "/noticias&page=", "Página", [
            "Primeira Página",
            "Primeira"
        ], [
            "Última Página",
            "Última"
        ]);
        $paginator->pager(
            $post->find(
                "status = :s AND (type = :t OR type = :tt)",
                "s=1&t=1&tt=2"
            )->count(),
            21,
            $page,
            2
        );
        /*
         * FIND POSTS
         */
        $posts = $post->find(
            "status = :s AND (type = :t OR type = :tt)",
            "s=1&t=1&tt=2"
        )
            ->order("created_at DESC")
            ->limit($paginator->limit())
            ->offset($paginator->offset())
            ->fetch(true);

        echo $this->template->render(
            "news",
            [
                /** MetaTags */
                "optimizer" => $this->optimizer->optimize(
                    "Notícias | " . SITE_TITLE,
                    "Acompanhe as notícias e últimas novidades do Senador Zequinha Marinho.",
                    HOME . "/noticias",
                    HOME . "/theme/images/index.jpg"
                )->render(),

                /** Data Page */
                "posts" => $posts,
                "paginator" => $paginator->render()
            ]
        );
    }

    public function videos()
    {
        $page = filter_input(INPUT_GET, "page", FILTER_VALIDATE_INT);
        $post = new Post();
        /*
             * PAGINATOR
             */
        $paginator = new Paginator(HOME . "/videos&page=", "Página", [
            "Primeira Página",
            "Primeira"
        ], [
            "Última Página",
            "Última"
        ]);
        $paginator->pager($post->find("status = :s AND type = :t", "s=1&t=3")->count(), 21, $page, 2);
        /*
         * FIND POSTS
         */
        $videos = $post->find("status = :s AND type = :t", "s=1&t=3")->order("created_at DESC")->limit($paginator->limit())->offset($paginator->offset())->fetch(true);

        echo $this->template->render(
            "videos",
            [
                /** MetaTags */
                "optimizer" => $this->optimizer->optimize(
                    "Vídeos | " . SITE_TITLE,
                    "Acompanhe a TV Zequinha e os últimos vídeos do Senador Zequinha Marinho.",
                    HOME . "/videos",
                    HOME . "/theme/images/index.jpg"
                )->render(),

                /** Data Page */
                "videos" => $videos,
                "paginator" => $paginator->render()
            ]
        );
    }

    public function view($data)
    {
        $uri = $data['post_uri'];
        if (empty($uri)) :
            header('Location: ' . HOME);
        endif;

        $post = (new Post())->find("uri = :uri", "uri={$uri}")->fetch();
        if (!$post) :
            header('Location:' . HOME . "/ooops/404");
        endif;

        $posts = (new Post())->find("id != :id AND (type = :t OR type = :tt)", "id={$post->id}&t=1&tt=2")
        ->order("created_at DESC")
        ->limit(5)
        ->fetch(true);

        /** POST VIEW */
        $pt = (new Post())->findById($post->id);
        $pt->view = $pt->view + 1;
        $pt->save();

        echo $this->template->render(
            "post",
            [
                /** MetaTags */
                "optimizer" => $this->optimizer->optimize(
                    "{$post->title} | " . SITE_TITLE,
                    "",
                    HOME . "/noticias/" . $post->uri,
                    HOME . '/' . $post->cover
                )->render(),

                /** Data Page */
                "post" => $post,
                "posts" => $posts,
                "gallery" => $post->getGallery()
            ]
        );
    }

    public function viewVideo($data)
    {
        $uri = $data['post_uri'];
        if (empty($uri)) :
            header('Location: ' . HOME);
        endif;

        $post = (new Post())->find("uri = :uri", "uri={$uri}")->fetch();
        if (!$post) :
            header('Location:' . HOME . "/ooops/404");
        endif;

        $videos = (new Post())->find("id != :id AND type = :t", "id={$post->id}&t=3")->order("created_at DESC")->limit(5)->fetch(true);

        /** POST VIEW */
        $pt = (new Post())->findById($post->id);
        $pt->view = $pt->view + 1;
        $pt->save();

        echo $this->template->render(
            "video",
            [
                /** MetaTags */
                "optimizer" => $this->optimizer->optimize(
                    "{$post->title} | " . SITE_TITLE,
                    "",
                    HOME . "/videos/" . $post->uri,
                    HOME . '/' . $post->cover
                )->render(),

                /** Data Page */
                "post" => $post,
                "videos" => $videos,
            ]
        );
    }
}
