<?php

use Source\Support\Helper;
use CoffeeCode\Cropper\Cropper;

$c = new Cropper("cache");

$v->layout('inc/layout');
?>

<section class="container padding-high bg-white mt-20">
    <div class="content">
        <header class="header-default t-center mb-80">
            <h1 class="f-semibold" style="color: rgba(0,120,186,0.5)">Vídeos</h1>
            <h2 class="f-semibold f-black">TV Guilherme Relvas</h2>
            <p class="f-black f-light text-page">Acompanhe a TV Guilherme Relvas e os últimos vídeos do Guilherme Relvas.</p>
        </header>

        <div class="content-videos second flex-container">
            <?php
            if ($videos) :
                foreach ($videos as $video) :
            ?>
                    <article class="transition">
                        <a href="<?= HOME ?>/videos/<?= $video->uri ?>">
                            <div class="photo">
                                <div class="cover blue2"></div>
                                <span class="play flex-container flex-justify-center flex-itens-center bg-white round"><i class="icon-play4 f-blue"></i></span>
                                <?= Helper::image($c->make($video->cover, 600, 350), $video->title, 'img') ?>
                            </div>
                            <header class="bg-silver">
                                <h2 class="f-blue f-semibold"><?= $video->title ?></h2>
                            </header>
                        </a>
                    </article>
            <?php
                endforeach;
            endif;
            ?>

        </div>

        <?= $paginator; ?>
    </div>
</section>