<?php

use Source\Support\Helper;
use CoffeeCode\Cropper\Cropper;

$c = new Cropper("cache");
$v->layout('inc/layout');
?>

<section class="container bg-silver padding-high">
    <div class="content">
        <header class="header-default mb-80">
            <h1 class="f-semibold" style="color: rgba(35,61,182,0.5)">Biografia</h1>
            <h2 class="f-semibold f-black">Júnior Ferrari</h2>
            <p class="f-black f-light text-page">Conheça a história e trajetória política:</p>
        </header>

        <div class="content-total-about">
            <div class="flex-container flex-wrap">
                <div class="flex flex60">
                    <div class="container padding-total-normal bg-white radius-m">
                        <h2 class="title-page-sec f-black f-semibold mb-30">Trajetória</h2>
                        <div class="about-text">
                            <p class="f-black f-light t-justify mb-20">
                                Com formação em Administração Pública pela Universidade Federal do Pará, desde janeiro de 2011, dedica-se a cargos públicos nos âmbitos Estadual e Federal.
 
                            </p>

                            <p class="f-black f-light t-justify mb-20">
                                Desempenhou o papel de Diretor Administrativo Financeiro na Fundação Cultural do Estado do Pará. Ao longo de sua trajetória na instituição, ocupou diversas posições de destaque, incluindo as de Secretário Executivo do Sistema Estadual de Bibliotecas Públicas, Coordenador de Fomento à Leitura, Coordenador de Promoção Editorial, Diretor de Leitura e Informação, além de ter sido Presidente da instituição.

                            </p>

                            <p class="f-black f-light t-justify mb-20">
                                Durante seu mandato como Presidente da Fundação Cultural, entre 2021 e 2022, foi responsável pela concepção e implementação de políticas públicas estratégicas. Destaca-se o Programa Cultura Pará, que representou o maior investimento de fomento para o setor cultural na história do Pará. Por meio de editais públicos, com recursos próprios, o programa beneficiou mais de 900 artistas, produtores e agentes culturais em 2023, com um montante histórico de repasses que ultrapassou os 17 milhões de reais. 
                            </p>

                        </div>
                    </div>
                </div>

                <div class="flex flex40 pl-30">
                    <article class="container mb-30">
                        <?= Helper::image($c->make(THEME . '/images/img1.jpg', 800, 700), 'Sobre a Meta', 'img radius-m') ?>
                    </article>

                    <article class="container mb-30">
                        <?= Helper::image($c->make(THEME . '/images/img2.jpg', 800, 700), 'Sobre a Meta', 'img radius-m') ?>
                    </article>

                    <article class="container">
                        <?= Helper::image($c->make(THEME . '/images/img3.jpg', 800, 700), 'Sobre a Meta', 'img radius-m') ?>
                    </article>
                </div>
            </div>
        </div>
    </div>
</section>