<?php
    
    namespace Source\Models\Admin;
    
    use Source\Models\Post;
    use Source\Models\Category;
    use Source\Models\GbPost;
    use Source\Support\Helper;
    use CoffeeCode\Uploader\Image;
    
    class AdminPost
    {
        private $data;
        private $result;
        private $error;
        private $post;
        private $postId;
        
        public function exeCreate(array $data)
        {
            $this->post = new Post();
            $this->data = $data;
            
            $description = $this->data['description'];
            $cover = (isset($_FILES['cover']) ? $_FILES['cover'] : false);
            $video = $this->data['video'];
            unset($this->data['description']);
            unset($this->data['cover']);
            unset($this->data['title_cover']);
            unset($this->data['video']);
            
            if (in_array('', $this->data)):
                $this->error = [
                    "<b>Erro ao cadastrar:</b> Você precisa preencher todos os campos para cadastrar um post!",
                    INFO
                ];
                $this->result = false;
            else:
                $this->data['cover'] = $cover;
                $this->data['description'] = $description;
                $this->data['video'] = $video;
                $this->post->description = $this->data['description'];
                
                $this->uri();
                $this->category();
                $this->cover();
                if ($this->result):
                    $this->status();
                    $this->create();
                endif;
            endif;
        }
        
        public function exeUpdate(array $data, int $id)
        {
            $this->post = (new Post())->findById($id);
            $this->data = $data;
            $this->postId = $id;
            
            $description = $this->data['description'];
            $cover = (isset($_FILES['cover']) ? $_FILES['cover'] : false);
            $video = $this->data['video'];
            unset($this->data['description']);
            unset($this->data['cover']);
            unset($this->data['title_cover']);
            unset($this->data['video']);

            if (in_array('', $this->data)):
                $this->error = [
                    "<b>Erro ao cadastrar:</b> Você precisa preencher todos os campos para cadastrar um post!",
                    INFO
                ];
                $this->result = false;
            else:
                $this->data['cover'] = $cover;
                $this->data['description'] = $description;
                $this->data['video'] = $video;
                $this->post->description = $this->data['description'];
                
                $this->uri();
                $this->category();
                $this->cover();
                if ($this->result):
                    $this->status();
                    $this->update();
                endif;
            endif;
        }
        
        public function exeDelete(int $id)
        {
            $this->postId = $id;
            $this->post = (new Post())->findById($this->postId);
            if (!$this->post):
                $this->result = false;
                $this->error = [
                    "<b class='f-bold'>Erro ao excluir:</b> Não foi possível encontrar o post que você está tentando excluir.",
                    ERROR
                ];
            else:
                /*
                 * EXCLUI IMAGEM
                 */
                unlink($this->post->cover);
                /*
                 * DESTROY
                 */
                $this->post->destroy();
                
                $this->result = true;
                $this->error = [
                    "<b class='f-bold'>Tudo certo:</b> O post foi excluído com sucesso do sistema",
                    ACCEPT
                ];
            endif;
        }
        
        public function gbSend(array $data)
        {
            $this->data = $data;
            $image = new Image("upload", "galerias/posts");
            
            $cover = (isset($_FILES['cover']) ? $_FILES['cover'] : false);
            $gbCount = count($cover['tmp_name']);
            unset($this->data['title_cover']);
            
            if (!$gbCount):
                $this->result = false;
                $this->error = [
                    "Você não enviou nenhuma imagem para a galeria deste post!",
                    ERROR
                ];
            else:
                $arr = [];
                $arrGb = null;
                for ($gb = 0; $gb < $gbCount; $gb++):
                    $arrGb['name'] = $cover['name'][$gb];
                    $arrGb['type'] = $cover['type'][$gb];
                    $arrGb['tmp_name'] = $cover['tmp_name'][$gb];
                    $arrGb['error'] = $cover['error'][$gb];
                    $arrGb['size'] = $cover['size'][$gb];
                    array_push($arr, $arrGb);
                    
                    $imgName = md5($arr[$gb]['name']) . time();
                    /*
                     * AUTENTICA ENVIO E TIPOS DE ARQUIVOS
                     */
                    if (empty($arr[$gb]['type'])):
                        $this->result = false;
                        $this->error = [
                            "<b class='f-bold'>Erro ao cadastrar:</b> Envie uma imagem válida!",
                            ERROR
                        ];
                    elseif (!in_array($arr[$gb]['type'], $image::isAllowed())):
                        $this->result = false;
                        $this->error = [
                            "<b class='f-bold'>Erro ao cadastrar:</b> O arquivo {$arr[$gb]['name']} não é válido!",
                            ERROR
                        ];
                    else:
                        $upload = $image->upload($arr[$gb], $imgName, 1150);
                        $this->data['cover'] = $upload;
                        $this->post = new GbPost();
                        $this->post->cover = $this->data['cover'];
                        $this->post->post = $this->data['post'];
                        $create = $this->post->save();
                    endif;
                endfor;
                
                if (!$create):
                    $this->result = false;
                    $this->error = [
                        "<b class='f-bold'>Erro ao cadastrar:</b> Não foi possível cadastrar a galeria no post!",
                        ERROR
                    ];
                else:
                    $this->result = true;
                    $this->error = [
                        "<b class='f-bold'>Tudo certo!</b> A Galeria foi enviada com sucesso!",
                        ACCEPT
                    ];
                endif;
            
            endif;
        }
        
        public function gbDelete(int $id)
        {
            $gbId = $id;
            $this->post = (new GbPost())->findById($gbId);
            
            if (!$this->post):
                $this->result = false;
                $this->error = [
                    "<b class='f-bold'>Erro ao excluir:</b> Não foi possível encontrar a imagem que você está tentando excluir.",
                    ERROR
                ];
            else:
                unlink($this->post->cover);
                $this->post->destroy();
                $this->result = true;
                $this->error = [
                    "<b class='f-bold'>Tudo certo:</b> A imagem foi excluída com sucesso da galeria.",
                    ERROR
                ];
            endif;
        }
        
        public function error()
        {
            return $this->error;
        }
        
        public function result()
        {
            return $this->result;
        }
        
        private function uri()
        {
            $this->data['uri'] = Helper::uri($this->data['title']);
            $this->post->uri = $this->data['uri'];
        }
        
        private function category()
        {
            $category = (new Category())->findById($this->data['category']);
            $this->data['parent'] = $category->parent;
            $this->post->category = $this->data['category'];
            $this->post->parent = $this->data['parent'];
        }
        
        private function status()
        {
            if (isset($this->data['status'])):
                $this->data['status'] = '1';
            else:
                $this->data['status'] = '0';
            endif;
            
            $this->post->status = $this->data['status'];
        }
        
        private function cover()
        {
            $image = new Image("upload", "posts");
            $imageCurrent = (isset($this->postId) ? $this->data['image_current'] : null);
            unset($this->data['image_current']);
            
            if (isset($this->postId)):
                if (!$this->data['cover']):
                    $this->data['cover'] = $imageCurrent;
                    $this->post->cover = $this->data['cover'];
                    $this->result = true;
                else:
                    /*
                     * AUTENTICA ENVIO E TIPOS DE ARQUIVOS
                     */
                    if (empty($this->data['cover']['type']) || !in_array($this->data['cover']['type'], $image::isAllowed())):
                        $this->result = false;
                        $this->error = [
                            "<b class='f-bold'>Erro ao cadastrar:</b> Envie uma imagem com formato válido.",
                            ERROR
                        ];
                    else:
                        $this->result = true;
                        /*
                         * EXCLUI A IMAGEM ANTERIOR
                         */
                        $post = $this->post->findById($this->postId);
                        foreach ($post as $p):
                            unlink($p->cover);
                        endforeach;
                        
                        $imgName = $this->data['uri'] . '-' . time();
                        $upload = $image->upload($this->data['cover'], $imgName, 1150);
                        $this->data['cover'] = $upload;
                        $this->post->cover = $this->data['cover'];
                    endif;
                endif;
            else:
                /*
                 * AUTENTICA ENVIO E TIPOS DE ARQUIVOS
                 */
                if (empty($this->data['cover']['type']) || !in_array($this->data['cover']['type'], $image::isAllowed())):
                    $this->result = false;
                    $this->error = [
                        "<b class='f-bold'>Erro ao cadastrar:</b> Envie uma imagem com formato válido.",
                        ERROR
                    ];
                else:
                    $this->result = true;
                    $imgName = $this->data['uri'] . '-' . time();
                    $upload = $image->upload($this->data['cover'], $imgName, 1150);
                    $this->data['cover'] = $upload;
                    $this->post->cover = $this->data['cover'];
                endif;
            endif;
        }
        
        private function create()
        {
            $this->post->title = $this->data['title'];
            $this->post->type = $this->data['type'];
            $this->post->video = $this->data['video'];
            $this->post->view = 0;
            
            $create = $this->post->save();
            if (!$create):
                $this->error = [
                    "<b>Erro ao cadastrar:</b> Não foi possível cadastrar o post no sistema!",
                    ERROR
                ];
                $this->result = false;
            else:
                $this->error = [
                    "<b>Tudo certo:</b> O post foi cadastrado com sucesso no sistema!",
                    ACCEPT
                ];
                $this->result = $this->post->data()->id;
            endif;
        }
        
        private function update()
        {
            $this->post->title = $this->data['title'];
            $this->post->type = $this->data['type'];
            $this->post->video = $this->data['video'];
            
            $update = $this->post->save();
            if (!$update):
                $this->error = [
                    "<b>Erro ao atualizar:</b> Não foi possível atualizar o post no sistema!",
                    ERROR
                ];
                $this->result = false;
            else:
                $this->error = [
                    "<b>Tudo certo:</b> O post foi atualizado com sucesso no sistema!",
                    ACCEPT
                ];
                $this->result = true;
            endif;
        }
    }