<?php

namespace Source\App\Web;

use League\Plates\Engine;
use CoffeeCode\Optimizer\Optimizer;
use Source\Models\Web\Message;

class Contact
{
    private $template;
    private $optimizer;

    public function __construct($router)
    {
        $this->template = Engine::create(THEME, FILE_EXT);
        $this->optimizer = new Optimizer();

        $this->template->addData([
            "router" => $router
        ]);
    }

    public function index()
    {
        echo $this->template->render(
            "contact",
            [
                /** MetaTags */
                "optimizer" => $this->optimizer->optimize(
                    "Contato | " . SITE_TITLE,
                    "Entre em contato conosco ou conheça alguns de nossos meios de comunicação.",
                    HOME . "/contato",
                    HOME . "/theme/images/index.jpg"
                )->render()
            ]
        );
    }

    public function send($data)
    {
        sleep(1);
        $json = [];
        unset($data['callback']);

        $setPost = array_map("strip_tags", $data);
        $post = array_map("trim", $setPost);

        $message = new Message();
        $message->send($post);

        if (!$message->result()) :
            $json['error'] = $message->error()[0];
        else :
            $json['accept'] = $message->error()[0];
            $json['clear'] = true;
        endif;

        echo json_encode($json);
    }
}
