<?php

namespace Source\App\Admin;

use League\Plates\Engine;
use Source\Models\Admin\AdminDash;
use Source\Models\Admin\AdminPost;
use Source\Models\Category;
use CoffeeCode\Paginator\Paginator;
use Source\Models\GbPost;

class Post
{
    private $template;

    public function __construct()
    {
        $this->template = Engine::create(ADMIN, FILE_EXT);

        $session = new AdminDash();
        $validate = $session->checkSession();
        if (!$validate) :
            header('Location:' . HOME . "/admin");
        endif;

        $checkLevel = $session->checkLevel($_SESSION['acesso']['nivel'], [1, 2]);
        if (!$checkLevel) :
            header('Location:' . HOME . "/admin");
        endif;
    }

    public function post($data)
    {
        $getType = (isset($data['type']) ? $data['type'] : null);
        $link = (!empty($getType) ? '/' . $getType : null);
        $type = ((!empty($getType) && $getType == 'videos') ? "AND type = '3'" : ((!empty($getType) && $getType == 'gallery') ? "AND type = '2'" : "AND type = '1'"));
        $placeTitle = ((!empty($getType) && $getType == 'videos') ? 3 : ((!empty($getType) && $getType == 'gallery') ? 2 : 1));
        $page = filter_input(INPUT_GET, "page", FILTER_VALIDATE_INT);
        $post = new \Source\Models\Post();
        /*
             * PAGINATOR POST
             */
        $paginator = new Paginator(HOME . "/admin/posts{$link}&page=", "Página", [
            "Primeira Página",
            "Primeira"
        ], [
            "Última Página",
            "Última"
        ]);
        $paginator->pager($post->find("id > :id {$type}", "id=0")->count(), 15, $page, 2);
        /*
             * FIND POSTS
             */
        $posts = $post->find("id > :id {$type}", "id=0")
            ->order("created_at DESC")
            ->limit($paginator->limit())
            ->offset($paginator->offset())
            ->fetch(true);

        echo $this->template->render("system/posts/index", [
            /** Data Page */
            "data" => $posts,
            "placeTitle" => $placeTitle,
            "link" => $link,
            "paginator" => $paginator->render()
        ]);
    }

    public function create($data)
    {
        $cate = (new Category())->find("parent != :p", "p=0")->order("title ASC")->fetch(true);
        echo $this->template->render("system/posts/create", ["cate" => $cate]);
    }

    public function update($data)
    {
        $post = new \Source\Models\Post();
        $cate = new Category();

        $p = $post->findById($data['id']);
        $categories = $cate->find("parent != :p", "p=0")->order("title ASC")->fetch(true);
        $gb = (new GbPost())->find("post = :p", "p={$data['id']}")->fetch(true);

        echo $this->template->render("system/posts/update", [
            "post" => $p,
            "categories" => $categories,
            "gb" => $gb
        ]);
    }

    public function managerPost($data)
    {
        sleep(1);
        $json = [];
        $text = $data['description'];
        unset($data['description']);
        unset($data['callback']);

        $setPost = array_map("strip_tags", $data);
        $post = array_map("trim", $setPost);

        $post['description'] = $text;
        $postId = (isset($post['id']) ? $post['id'] : '');

        $adminPost = new AdminPost();

        if (!empty($postId)) :
            $adminPost->exeUpdate($post, $postId);
            if (!$adminPost->result()) :
                $json['error'] = $adminPost->error()[0];
            else :
                $json['accept'] = $adminPost->error()[0];
            endif;
        else :
            $adminPost->exeCreate($post);
            if (!$adminPost->result()) :
                $json['error'] = $adminPost->error()[0];
            else :
                $json['accept'] = $adminPost->error()[0];
                $json['redirect'] = HOME . "/admin/posts";
                $json['time'] = 2000;
                $Json['clear'] = true;
            endif;
        endif;

        echo json_encode($json);
    }

    public function delete($data)
    {
        sleep(1);
        $json = [];

        $setPost = array_map("strip_tags", $data);
        $post = array_map("trim", $setPost);

        $id = (isset($post['id']) ? $post['id'] : false);

        if ($id) :
            $adminPost = new AdminPost();
            $adminPost->exeDelete($id);
            if (!$adminPost->result()) :
                $json['error'] = $adminPost->error()[0];
            else :
                $json['accept'] = $adminPost->error()[0];
                $json['redirect'] = HOME . "/admin/posts";
                $json['time'] = 2000;
            endif;
        else :
            $json['error'] = "Não foi possivel processar a operação";
        endif;

        echo json_encode($json);
    }

    public function gbCreate($data)
    {
        sleep(1);
        $json = [];

        $setPost = array_map("strip_tags", $data);
        $post = array_map("trim", $setPost);

        $id = $post['post'];

        $adminPost = new AdminPost();
        $adminPost->gbSend($post);
        if (!$adminPost->result()) :
            $json['error'] = $adminPost->error()[0];
        else :
            $json['accept'] = $adminPost->error()[0];
            $json['clear'] = true;
            $json['redirect'] = HOME . "/admin/posts/update/{$id}";
            $json['time'] = 2000;
        endif;

        echo json_encode($json);
    }

    public function gbDelete($data)
    {
        sleep(1);
        $json = [];

        $setPost = array_map("strip_tags", $data);
        $post = array_map("trim", $setPost);

        $id = (isset($post['id']) ? $post['id'] : false);

        if ($id) :
            $adminPost = new AdminPost();
            $adminPost->gbDelete($id);
            if (!$adminPost->result()) :
                $json['error'] = $adminPost->error()[0];
            else :
                $json['accept'] = $adminPost->error()[0];
            endif;
        else :
            $json['error'] = "Não foi possivel processar a operação";
        endif;

        echo json_encode($json);
    }
}
