<?php

namespace Source\App\Admin;

use League\Plates\Engine;
use Source\Models\Admin\AdminCategory;
use Source\Models\Admin\AdminDash;

class Category
{
    private $template;

    public function __construct()
    {
        $this->template = Engine::create(ADMIN, FILE_EXT);

        $session = new AdminDash();
        $validate = $session->checkSession();
        if (!$validate) :
            header('Location:' . HOME . "/admin");
        endif;

        $checkLevel = $session->checkLevel($_SESSION['acesso']['nivel'], [1, 2]);
        if (!$checkLevel) :
            header('Location:' . HOME . "/admin");
        endif;
    }

    public function index($data)
    {
        $parents = new \Source\Models\Category();
        $pa = $parents->find("parent = :p", "p=0")->order("title ASC")->fetch(true);

        echo $this->template->render("system/categories/index", [
            "parents" => $pa
        ]);
    }

    public function create($data)
    {
        $parents = new \Source\Models\Category();
        $pa = $parents->find("parent = :p", "p=0")->order("title ASC")->fetch(true);

        echo $this->template->render("system/categories/create", [
            "parents" => $pa
        ]);
    }

    public function update($data)
    {
        $cate = new \Source\Models\Category();
        $pa = $cate->find("parent = :p", "p=0")->order("title ASC")->fetch(true);
        $category = $cate->findById($data['id']);

        echo $this->template->render("system/categories/update", [
            "category" => $category,
            "parents" => $pa,
        ]);
    }

    public function managerCate($data)
    {
        sleep(1);
        $json = [];
        unset($data['callback']);

        $setPost = array_map("strip_tags", $data);
        $post = array_map("trim", $setPost);

        $id = (isset($post['id']) ? $post['id'] : '');

        $adminCate = new AdminCategory();

        if (!empty($id)) :
            $adminCate->exeUpdate($post, $id);
            if (!$adminCate->result()) :
                $json['error'] = $adminCate->error()[0];
            else :
                $json['accept'] = $adminCate->error()[0];
            endif;
        else :
            $adminCate->exeCreate($post);
            if (!$adminCate->result()) :
                $json['error'] = $adminCate->error()[0];
            else :
                $json['accept'] = $adminCate->error()[0];
                $json['redirect'] = HOME . "/admin/categories";
                $json['time'] = 2000;
                $Json['clear'] = true;
            endif;
        endif;

        echo json_encode($json);
    }

    public function delete($data)
    {
        sleep(1);
        $json = [];

        $setPost = array_map("strip_tags", $data);
        $post = array_map("trim", $setPost);

        $id = (isset($post['id']) ? $post['id'] : false);

        if ($id) :
            $adminCate = new AdminCategory();
            $adminCate->exeDelete($id);
            if (!$adminCate->result()) :
                $json['error'] = $adminCate->error()[0];
            else :
                $json['accept'] = $adminCate->error()[0];
                $json['redirect'] = HOME . "/admin/categories";
                $json['time'] = 2000;
            endif;
        else :
            $json['error'] = "Não foi possivel processar a operação";
        endif;

        echo json_encode($json);
    }
}
