<?php

use Source\Support\Helper;
use CoffeeCode\Cropper\Cropper;

$c = new Cropper("cache");
$v->layout('inc/layout');
?>

<section class="container bg-silver padding-high">
    <div class="content">
        <header class="header-default mb-80">
            <h1 class="f-semibold" style="color: rgba(139,202,167,0.5)">Sobre</h1>
            <h2 class="f-semibold f-black">Cristão Pará</h2>
            <p class="f-black f-light text-page">Conheça um pouco mais:</p>
        </header>

        <div class="content-total-about">
            <div class="flex-container flex-wrap">
                <div class="flex flex60">
                    <div class="container padding-total-normal bg-white radius-m">
                        <!--<h2 class="title-page-sec f-black f-semibold mb-30">Trajetória</h2>-->
                        <div class="about-text">
                            <p class="f-black f-light t-justify mb-20">
                               O Cristão Pará nasceu do desejo de unir a informação à fé, oferecendo um espaço dedicado a divulgar notícias, histórias, eventos e tudo o que movimenta o cenário cristão no Estado do Pará. Em meio a um mundo acelerado e muitas vezes carente de boas referências, entendemos a importância de uma mídia que valorize os princípios cristãos, a ética jornalística e a verdade.

                            </p>

                            <p class="f-black f-light t-justify mb-20">
                                Nosso objetivo é ser uma ponte entre a comunidade cristã e os acontecimentos relevantes do nosso tempo — sejam eles locais, regionais, nacionais ou internacionais. Acreditamos que a fé cristã deve estar presente em todas as esferas da sociedade, inclusive na comunicação.
                            </p>

                            <p class="f-black f-light t-justify mb-20">
                                No Cristão Pará, você encontra:
                            </p>

                            <p class="f-black f-light t-justify mb-20">
                                Cobertura de eventos cristãos no Pará e região;

Notícias sobre igrejas, ministérios e ações sociais;

Reflexões e devocionais;

Reportagens especiais que inspiram, informam e edificam.
                            </p>

                            <p class="f-black f-light t-justify mb-20">
                                Mais do que informar, queremos contribuir para a edificação do Corpo de Cristo, fortalecendo a fé dos leitores e promovendo a união do povo de Deus. Somos uma equipe comprometida com a missão de comunicar com excelência, responsabilidade e temor ao Senhor.
                            </p>

                            <p class="f-black f-light t-justify mb-20">
                               Cristão Pará: uma voz cristã na imprensa paraense.
                            </p>
                            <!--<p class="f-black f-light t-justify mb-20">
                                Além disso, é membro de nove Comissões Permanentes do Senado e, em 2019, perante
                                a Comissão Mista de Orçamento (um dos principais colegiados do Congresso Nacional)
                                foi escolhido por seus pares para ser relator da Receita do Orçamento de 2020
                                – missão de grande relevância para ajudar a União a reduzir o déficit fiscal
                                e aumentar o volume de investimentos no país.
                            </p>-->
                        </div>
                    </div>
                </div>

                <div class="flex flex40 pl-30">
                    <article class="container mb-30">
                        <?= Helper::image($c->make(THEME . '/images/logo.png', 1400, 700), 'Sobre a Meta', 'img radius-m') ?>
                    </article>

                    <!--<article class="container mb-30">
                        <?= Helper::image($c->make(THEME . '/images/img2.jpg', 800, 700), 'Sobre a Meta', 'img radius-m') ?>
                    </article>

                    <article class="container">
                        <?= Helper::image($c->make(THEME . '/images/img2.jpg', 800, 700), 'Sobre a Meta', 'img radius-m') ?>
                    </article>-->
                </div>
            </div>
        </div>
    </div>
</section>