<?php

namespace Source\App\Web;

use League\Plates\Engine;
use CoffeeCode\Optimizer\Optimizer;
use Source\Models\Post;

class Home
{
    private $template;
    private $optimizer;

    public function __construct($router)
    {
        $this->template = Engine::create(THEME, FILE_EXT);
        $this->optimizer = new Optimizer();

        $this->template->addData([
            "router" => $router
        ]);
    }

    public function home()
    {
        /** POSTS */
        $postsBanner = (new Post())->find("status = :s AND (type = :t OR type = :tt)", "s=1&t=1&tt=2")
            ->order("created_at DESC")
            ->limit(3)
            ->fetch(true);

        $postsSecond = (new Post())->find("status = :s AND (type = :t OR type = :tt)", "s=1&t=1&tt=2")
            ->order("created_at DESC")
            ->limit(2)
            ->offset(3)
            ->fetch(true);

        $videos = (new Post())->find("status = :s AND type = :t", "s=1&t=3")
            ->order("created_at DESC")
            ->limit(3)
            ->fetch(true);

        echo $this->template->render(
            "home",
            [
                /** MetaTags */
                "optimizer" => $this->optimizer->optimize(
                    SITE_TITLE,
                    SITE_DESC,
                    HOME,
                    HOME . "/theme/images/index.jpg"
                )->render(),
                "postsBanner" => $postsBanner,
                "postsSecond" => $postsSecond,
                "videos" => $videos
            ]
        );
    }

    public function whatsapp($data)
    {
        $name = (!empty($data['name']) ? $data['name'] : false);
        $message = (!empty($data['message']) ? $data['message'] : false);

        if ($name && $message) :
            $textWhastapp = "Olá, me chamo {$name}, {$message}";
        else :
            $textWhastapp = "Olá, gostaria de iniciar um atendimento.";
        endif;

        header("Location:" . WHATSAPP_LINK . "&text={$textWhastapp}");
    }

    public function error($data)
    {
        if ($data['errcode'] == '400') :
            $Error = "Ocorreu um erro";
        elseif ($data['errcode'] == '404') :
            $Error = "Nada encontrado";
        elseif ($data['errcode'] == '405') :
            $Error = "Este método não é permitido";
        elseif ($data['errcode']) :
            $Error = "Isto não foi implementado";
        endif;

        echo $this->template->render(
            "error",
            [
                /** MetaTags */
                "optimizer" => $this->optimizer->optimize(
                    "Erro {$data['errcode']} - {$Error} - " . SITE_TITLE,
                    '',
                    HOME . "/ooops/{$data['errcode']}",
                    HOME . "/theme/images/index.jpg"
                )->render(),

                /** Data Page */
                "error" => "Erro {$data['errcode']} - {$Error}",
                "desc_page" => "Clique no botão abaixo para voltar à página home e continue navegando em nosso site.",
            ]
        );
    }
}
