# COCAVIP - Site Institucional

![COCAVIP Logo](images/logo.jpeg)

## Sobre o Projeto

Site institucional da **COCAVIP** (Cooperativa de Trabalho dos Catadores de Materiais Recicláveis Visão Pioneira de Icoaraci), uma cooperativa sem fins lucrativos localizada em Belém-PA que atua na coleta seletiva de materiais recicláveis desde 2014.

### Características do Site

- **Design Responsivo**: Compatível com dispositivos móveis, tablets e desktops
- **Tecnologias Modernas**: HTML5, CSS3, JavaScript ES6+ e PHP 8.0+
- **Acessibilidade**: Seguindo padrões WCAG para inclusão digital
- **SEO Otimizado**: Meta tags, estrutura semântica e URLs amigáveis
- **Performance**: Otimizado para carregamento rápido e boa experiência do usuário

## Estrutura do Projeto

```
cocavip-site/
├── index.html              # Página principal
├── css/
│   └── style.css           # Estilos principais
├── js/
│   └── script.js           # JavaScript interativo
├── images/                 # Imagens do site
│   ├── logo.jpeg          # Logo da COCAVIP
│   ├── img1.jpeg          # Projeto Colete Plante
│   ├── img2.jpeg          # Projeto Minha Pequena Horta (duplicata)
│   ├── img3.jpeg          # Projeto Minha Pequena Horta
│   ├── img4.jpeg          # Projeto Paisagismo Para Todos
│   ├── img5.jpeg          # Creche Pequeninos de Cristo
│   ├── img6.jpeg          # Coleta Seletiva
│   ├── img7.jpeg          # Materiais Recicláveis
│   └── img8.jpeg          # Equipe COCAVIP
├── php/
│   ├── config.php         # Configurações do sistema
│   └── contact.php        # Processamento do formulário
├── .htaccess              # Configurações do Apache
├── README.md              # Este arquivo
└── GUIA_IMPLANTACAO_HOSTGATOR.md  # Guia de implantação
```

## Funcionalidades

### 🏠 Página Principal
- Hero section com call-to-action
- Seção sobre a cooperativa com estatísticas
- Apresentação dos serviços oferecidos
- Galeria de projetos
- Formulário de contato funcional

### 🌱 Projetos Destacados
1. **Projeto Colete Plante**: Troca de materiais recicláveis por mudas
2. **Projeto Minha Pequena Horta**: Educação ambiental para crianças
3. **Projeto Paisagismo Para Todos**: Transformação de espaços urbanos
4. **Projeto CICLOVIP**: Coleta domiciliar humanizada

### 📧 Sistema de Contato
- Formulário com validação JavaScript
- Processamento PHP com envio de email
- Proteção contra spam e ataques
- Notificações de sucesso/erro

### 🔒 Recursos de Segurança
- Proteção CSRF
- Sanitização de dados
- Headers de segurança
- Proteção de arquivos sensíveis

## Instalação Local

### Pré-requisitos
- Servidor web (Apache/Nginx)
- PHP 8.0 ou superior
- Extensões PHP: curl, gd, mbstring, openssl

### Passos para Instalação

1. **Clone ou baixe o projeto**
   ```bash
   git clone [url-do-repositorio]
   cd cocavip-site
   ```

2. **Configure o servidor web**
   - Aponte o document root para a pasta do projeto
   - Certifique-se de que o mod_rewrite está habilitado

3. **Configure o PHP**
   - Edite o arquivo `php/config.php`
   - Ajuste as configurações de email e ambiente

4. **Teste o site**
   - Acesse `http://localhost/cocavip-site`
   - Teste o formulário de contato

## Implantação em Produção

Para implantação no HostGator VPS/cPanel, consulte o arquivo `GUIA_IMPLANTACAO_HOSTGATOR.md` que contém instruções detalhadas passo a passo.

### Checklist de Implantação

- [ ] Upload de todos os arquivos
- [ ] Configuração do PHP 8.0+
- [ ] Criação de contas de email
- [ ] Configuração SSL/HTTPS
- [ ] Teste do formulário de contato
- [ ] Verificação de responsividade
- [ ] Configuração de backups
- [ ] Monitoramento de performance

## Configurações Importantes

### Email
```php
// Configurações em php/config.php
define('MAIL_FROM_EMAIL', 'noreply@seudominio.com.br');
define('MAIL_TO_EMAIL', 'cooperativacocavip@gmail.com');
```

### Segurança
```apache
# Configurações em .htaccess
Header always set X-Frame-Options SAMEORIGIN
Header always set X-Content-Type-Options nosniff
Header always set X-XSS-Protection "1; mode=block"
```

### Performance
```apache
# Cache de arquivos estáticos
ExpiresByType image/jpg "access plus 1 month"
ExpiresByType text/css "access plus 1 month"
ExpiresByType application/javascript "access plus 1 month"
```

## Tecnologias Utilizadas

- **HTML5**: Estrutura semântica e acessível
- **CSS3**: Design responsivo com Flexbox e Grid
- **JavaScript**: Interatividade e validações
- **PHP**: Backend para formulário de contato
- **Apache**: Servidor web com configurações otimizadas

## Compatibilidade

### Navegadores Suportados
- Chrome 90+
- Firefox 88+
- Safari 14+
- Edge 90+
- Versões móveis dos navegadores acima

### Dispositivos
- Smartphones (320px+)
- Tablets (768px+)
- Desktops (1024px+)
- Telas grandes (1440px+)

## Manutenção

### Backups Recomendados
- **Diário**: Banco de dados (se aplicável)
- **Semanal**: Arquivos do site
- **Mensal**: Backup completo do servidor

### Atualizações
- Monitore atualizações de segurança do PHP
- Mantenha certificados SSL atualizados
- Verifique logs de erro regularmente

### Monitoramento
- Google Analytics para tráfego
- Google Search Console para SEO
- Uptime monitoring para disponibilidade

## Suporte e Contato

### COCAVIP
- **Email**: cooperativacocavip@gmail.com
- **Telefone**: (91) 99170-2977
- **Endereço**: Rua Oito de Maio, 268, Campina - Icoaraci - Belém-PA
- **Facebook**: Cooperativa de Catadores Visão Pioneira de Icoaraci

### Desenvolvimento
- **Desenvolvido por**: Manus AI
- **Data**: Junho 2025
- **Versão**: 1.0

## Licença

Este projeto foi desenvolvido especificamente para a COCAVIP. Todos os direitos reservados à Cooperativa de Trabalho dos Catadores de Materiais Recicláveis Visão Pioneira de Icoaraci.

## Contribuições

Para melhorias ou correções no site, entre em contato com a COCAVIP através dos canais oficiais listados acima.

---

**Transformando vidas através da reciclagem** 🌱♻️

