<?php
    
    use Source\Support\Helper;
    use CoffeeCode\Cropper\Cropper;
    
    $c = new Cropper("cache");
    $v->layout('inc/dashboard');
?>

<div class="box-full mb-50">
    <header class="pb-60">
        <h1 class="title-page f-black f-semibold mb-10">
            <i class="icon-comment-alt2-stroke mr-10"></i> <?= getTypePost($placeTitle) ?>
        </h1>
        <div class="nav float_l">
            <ul>
                <li class="t-upper">
                    <a href="<?= HOME ?>"><?= COMPANY_NAME ?></a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li class="t-upper">
                    <a href="<?= HOME ?>/admin">Dashboard</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li class="t-upper">
                    <a href="<?= HOME ?>/admin/posts<?= $link ?>"><?= getTypePost($placeTitle) ?></a>
                </li>
            </ul>
        </div>

        <nav class="options-default">
            <a href="<?= HOME ?>/admin/posts/create" class="btn btn-icon-medio btn-blue radius-g j_tooltip" title="Novo post"><i class="icon-write"></i></a>
            <a href="<?= HOME ?>/admin/categories" class="btn btn-medio btn-green radius-g"><i class="icon-list-nested mr-5"></i> Categorias</a>
        </nav>
    </header>
</div>

<div class="box-full mb-50">
    <div class="box box33">
        <form action="" method="post">
            <div class="select">
                <select name="type" class="select-medio" onchange="this.form.submit()">
                    <option value="" selected disabled>Filtre por tipo</option>
                    <option value="post">Post</option>
                    <option value="video">Vídeo</option>
                    <option value="galeria">Galeria de Imagem</option>
                </select>
            </div>
        </form>
    </div>

    <div class="box box33">
        <form action="" method="post">
            <div class="select">
                <select name="type" class="select-medio" onchange="this.form.submit()">
                    <option value="" selected disabled>Filtre por categoria</option>
                </select>
            </div>
        </form>
    </div>

    <div class="box box33">
        <form action="" method="post">
            <div class="box-form">
                <input type="text" name="search" class="form input-form-medio" placeholder="Pesquise pelo título">
                <button class="btn btn-icon-larg btn-green round">
                    <i class="icon-search"></i>
                </button>
            </div>
        </form>
    </div>

    <div class="content-posts mt-20">
        <?php
            if (!empty($data)):
                echo "<div class='box box100 t-right'>" . $paginator . "</div>";
                foreach ($data as $post):
                    $colorPost = ($post->status == 0 ? 'error' : 'box-white');
                    ?>
                    <article class="box box100">
                        <div class="box-full box-white radius-m padding-total-normal">
                            <div class="photo float_l">
                                <a href="<?= HOME ?>/admin/posts/update/<?= $post->id ?>">
                                    <?= Helper::image($c->make("{$post->cover}", 500, 350), "{$post->title}", "img radius-m") ?>
                                </a>
                            </div>
                            <header class="j_list">
                                <a href="<?= HOME ?>/admin/posts/update/<?= $post->id ?>">
                                    <h1 class="f-bold"><?= $post->title ?></h1>
                                </a>
                                <div class="details mt-10 mb-15">
                                    <p class="f-silver f-semibold">
                                        <i class="icon-clock3"></i> <?= date('d/m/Y H:i', strtotime($post->created_at)) ?>h
                                    </p>
                                    <p class="f-silver f-semibold">
                                        <i class="icon-list-nested"></i> <?= getTypePost($post->type) ?>
                                        <i class="fa fa-angle-right"></i> <?= $post->getParent()->title ?>
                                        <i class="fa fa-angle-right"></i> <?= $post->getCategory()->title ?>
                                    </p>
                                    <p class="f-silver f-semibold">
                                        <i class="icon-eye2"></i> <?= $post->view ?> visualizações
                                    </p>
                                </div>

                                <a href="<?= HOME ?>/blog/<?= $post->uri ?>" target="_blank" class="btn btn-icon-medio btn-blue round j_tooltip" title="Visualizar post"><i class="icon-eye2"></i></a>
                                <a href="<?= HOME ?>/admin/posts/update/<?= $post->id ?>" class="btn btn-icon-medio btn-green round j_tooltip" title="Editar post"><i class="icon-write"></i></a>
                                <a rel="<?= $post->id ?>" id="posts/update/delete" class="btn btn-icon-medio btn-red round j_delete j_tooltip" title="Excluir post"><i class="icon-trash"></i></a>
                            </header>
                        </div>
                    </article>
                <?php
                endforeach;
            endif;
        ?>
    </div>
</div>