<?php
    
    namespace Source\Routes;
    
    use CoffeeCode\Router\Router;
    
    class Route
    {
        private $router;
        
        public function __construct()
        {
            $this->router = new Router(HOME);
            
            /*
             * CONTROLLERS
             */
            $this->router->namespace("Source\App\Web");
            
            /*
             * HOME
             * home
             */
            $this->router->group(null);
            $this->router->get("/", "Home:home");
            $this->router->post("/load", "Home:load");
            $this->router->post("/loadunity", "Home:unity", "home.unity");
            $this->router->post("/whatsapp/send", "Home:whatsapp");
    
            /*
             * ABOUT
             * about
             */
            $this->router->get("/biografia", "About:index");
            
            /*
             * NEWS
             * index
             */
            $this->router->group("noticias");
            $this->router->get("/", "News:index");
            $this->router->get("/{post_uri}", "News:view");

            /*
             * VIDEOS
             * videos
             */
            $this->router->group("videos");
            $this->router->get("/", "News:videos");
            $this->router->get("/{post_uri}", "News:viewVideo");
            
            /*
             * CONTACT
             * index
             */
            $this->router->group(null);
            $this->router->get("/contato", "Contact:index");
            $this->router->post("/contato/send", "Contact:send");

            /*
             * ERROS
             */
            $this->router->group("ooops");
            $this->router->get("/{errcode}", "Home:error");
    
            /*
             * GENERATE
             * post | user
             */
            $this->router->group("samples")->namespace("Source\Samples");
            $this->router->get("/generate-post", "GeneratePost:post");
            $this->router->get("/generate-serv", "GenerateServ:serv");
            
            /*
             * ADMIN
             * dash
             */
            $this->router->group("admin")->namespace("Source\App\Admin");
            $this->router->get("/", "Dash:dash");
            $this->router->post("/getstates", "Dash:getStates", "states.get");
            $this->router->post("/getcitysbystate", "Dash:getCitysByState", "citys.get");
            $this->router->post("/getdistrictsbycity", "Dash:getDistrictsByCity", "districts.get");
            $this->router->post("/login", "Dash:login");
            $this->router->post("/logout", "Dash:logout");
            
            /**
             * ADMIN
             * posts
             */
            $this->router->get("/posts", "Post:post");
            $this->router->get("/posts/{type}", "Post:post");
            $this->router->get("/posts/create", "Post:create");
            $this->router->get("/posts/update/{id}", "Post:update");
            $this->router->post("/posts/manager", "Post:managerPost");
            $this->router->post("/posts/update/manager", "Post:managerPost");
            $this->router->post("/posts/update/delete", "Post:delete");
            $this->router->post("/posts/update/gb", "Post:gbCreate");
            $this->router->post("/posts/update/gbdelete", "Post:gbDelete");
    
            /**
             * ADMIN
             * categories
             */
            $this->router->get("/categories", "Category:index");
            $this->router->get("/categories/create", "Category:create");
            $this->router->get("/categories/update/{id}", "Category:update");
            $this->router->post("/categories/manager", "Category:managerCate");
            $this->router->post("/categories/update/manager", "Category:managerCate");
            $this->router->post("/categories/update/delete", "Category:delete");
            
            /**
             * ADMIN
             * messages
             */
            $this->router->get("/messages", "Message:index");
            $this->router->get("/messages/read/{id}", "Message:read");
            $this->router->post("/messages/read/delete", "Message:delete");

            /**
             * ADMIN
             * records
             */
            $this->router->get("/records", "Record:index");
            $this->router->get("/records/create", "Record:create");
            $this->router->get("/records/view/{id}", "Record:view");
            $this->router->post("/records/manager", "Record:manager", "record.manager");
    
            /**
             * ADMIN
             * analytics
             */
            $this->router->get("/analytics", "Analytic:index");
            $this->router->get("/analytics/usersonline", "Analytic:usersOnline");
            $this->router->get("/analytics/listmonth", "Analytic:month");
            $this->router->post("/analytics/listmonth", "Analytic:month");
            
            /**
             * ADMIN
             * users/config
             */
            $this->router->get("/config", "Config:index");
            $this->router->post("/config/contact", "Config:updateContact");
            $this->router->post("/config/social", "Config:updateSocial");
            $this->router->get("/users", "User:index");
            $this->router->get("/users/create", "User:create");
            $this->router->get("/users/update/{id}", "User:update");
            $this->router->post("/users/manager", "User:managerUser");
            $this->router->post("/users/update/manager", "User:managerUser");
            $this->router->post("/users/update/delete", "User:delete");
            
            /*
             * CRON TABS
             * notify
             */
            $this->router->group("cron")->namespace("Source\App\Cron");
            $this->router->post("/pagarme/return", "Cron:pagarmeReturn");

            $this->router->dispatch();
    
            if ($this->router->error()):
                $this->router->redirect("/ooops/{$this->router->error()}");
            endif;
            
        }
    }