<?php
    
    namespace Source\Models\Admin;
    
    use Source\Models\Social;
    
    class AdminSocial
    {
        private $data;
        private $result;
        private $error;
        private $id;
        private $social;
        
        public function exeUpdate(array $data, int $id)
        {
            $this->data = $data;
            $this->id = $id;
            $this->social = (new Social())->findById($this->id);
            $this->update();
        }
        
        public function result()
        {
            return $this->result;
        }
        
        public function error()
        {
            return $this->error;
        }
        
        private function update()
        {
            $this->social->facebook = $this->data['facebook'];
            $this->social->instagram = $this->data['instagram'];
            $this->social->google = $this->data['google'];
            $this->social->twitter = $this->data['twitter'];
            $this->social->youtube = $this->data['youtube'];
            
            $update = $this->social->save();
            
            if (!$update):
                $this->error = [
                    "<b>Erro ao atualizar:</b> Não foi possível atualizar as redes sociais no sistema!",
                    ERROR
                ];
                $this->result = false;
            else:
                $this->error = [
                    "<b>Tudo certo:</b> As redes sociais foram atualizadas com sucesso!",
                    ACCEPT
                ];
                $this->result = true;
            endif;
        }
    }