<?php

namespace Source\App\Web;

use League\Plates\Engine;
use CoffeeCode\Optimizer\Optimizer;

class About
{
    private $template;
    private $optimizer;

    public function __construct($router)
    {
        $this->template = Engine::create(THEME, FILE_EXT);
        $this->optimizer = new Optimizer();

        $this->template->addData([
            "router" => $router
        ]);
    }

    public function index($data)
    {
        echo $this->template->render("about", [
            /** MetaTags */
            "optimizer" => $this->optimizer->optimize(
                "Sobre | " . SITE_TITLE,
                SITE_DESC,
                HOME . "/sobre",
                HOME . "/theme/images/index.jpg"
            )->render()
        ]);
    }
}
