<?php

use Source\Support\Helper;

$v->layout('inc/dashboard');
?>

<div class="box-full mb-50">
    <header class="pb-60">
        <h1 class="title-page f-black f-semibold mb-10">
            <i class="icon-write mr-10"></i> Visualizar cadastro
        </h1>
        <div class="nav float_l">
            <ul>
                <li class="t-upper">
                    <a href="<?= HOME ?>"><?= COMPANY_NAME ?></a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li class="t-upper">
                    <a href="<?= HOME ?>/admin">Dashboard</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li class="t-upper">
                    <a href="<?= HOME ?>/admin/records">Cadastros</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li class="t-upper">
                    <a href="<?= HOME ?>/admin/records/view/<?= $record->id ?>">Visualizar cadastro</a>
                </li>
            </ul>
        </div>

        <nav class="options-default">
            <a href="<?= HOME ?>/admin/records" class="btn btn-icon-medio btn-blue radius-g"><i class="icon-arrow-left2"></i></a>
            <a onclick="inputDisabled()" rel="1" class="btn btn-medio btn-green radius-g" id="buttonDisabled"><i class="icon-write"></i> Editar dados</a>
        </nav>
    </header>
</div>

<div class="box-full">
    <form action="" method="post" class="j_formajax" enctype="multipart/form-data">
        <div class="box box70">
            <input type="hidden" name="callback" value="<?= $router->route('record.manager') ?>" class="noclear">
            <input type="hidden" name="id" value="<?= $record->id ?>" class="noclear">

            <div class="box box100">
                <div class="box-full padding-total-normal radius-p box-white mb-30" style="border: 1px solid seagreen;">
                    <h3 class="title-page-sec f-semibold f-black t-upper">Dados pessoais:</h3>
                </div>
            </div>

            <label class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">Nome <span class="f-red">*</span></small>
                <input type="text" name="name" required class="form input-form-larg form-disabled" disabled placeholder="Nome" value="<?= $record->name ?>">
            </label>

            <label class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">Sobrenome <span class="f-red">*</span></small>
                <input type="text" name="lastname" required class="form input-form-larg form-disabled" disabled placeholder="Sobrenome" value="<?= $record->lastname ?>">
            </label>

            <label class="box box50">
                <small class="small-titulo-2 f-silver f-semibold t-upper">Gênero <span class="f-red">*</span></small>
                <div class="select form-disabled">
                    <select name="genre" class="select-medio" disabled required>
                        <option value="" selected disabled>Selecione um gênero</option>
                        <?php
                        foreach (getGenre() as $k => $v) :
                            echo "<option value='{$k}' " . ($k == $record->genre ? 'selected' : null) . ">" . ($k == $record->genre ? '&raquo; ' : null) . " {$v}</option>";
                        endforeach;
                        ?>
                    </select>
                </div>
            </label>

            <label class="box box50">
                <small class="small-titulo-2 f-silver f-semibold t-upper">Nascimento <span class="f-red">*</span></small>
                <input type="text" name="birth" required disabled class="form input-form-medio formAniver form-disabled" placeholder="dd/mm/aaaa" value="<?= date('d/m/Y', strtotime($record->birth)) ?>">
            </label>

            <div class="box box100">
                <div class="box-full padding-total-normal radius-p box-white mb-30 mt-30" style="border: 1px solid seagreen;">
                    <h3 class="title-page-sec f-semibold f-black t-upper">Dados de contato:</h3>
                </div>
            </div>

            <label class="box box50">
                <small class="small-titulo-2 f-silver f-semibold t-upper">Celular / Whatsapp <span class="f-red">*</span></small>
                <input type="text" name="phone" required disabled class="form input-form-medio formFone form-disabled" placeholder="Celular" value="<?= $record->phone ?>">
            </label>

            <div class="box box100">
                <div class="box-full padding-total-normal radius-p box-white mb-30 mt-30" style="border: 1px solid seagreen;">
                    <h3 class="title-page-sec f-semibold f-black t-upper">Dados de endereço:</h3>
                </div>
            </div>

            <label class="box box50">
                <small class="small-titulo-2 f-silver f-semibold t-upper">Cidade <span class="f-red">*</span></small>
                <div class="select form-disabled">
                    <select name="city" id="city" class="select-medio" rel="<?= $router->route('districts.get') ?>" required disabled>
                        <option value="" selected disabled>Selecione uma cidade</option>
                        <?php
                        if ($citys) :
                            foreach ($citys as $city) :
                                echo "<option value='{$city->id}' " . ($city->id == $record->city ? 'selected' : null) . ">" . ($city->id == $record->city ? '&raquo; ' : null) . "{$city->name}</option>";
                            endforeach;
                        endif;
                        ?>
                    </select>
                </div>
            </label>

            <label class="box box50">
                <small class="small-titulo-2 f-silver f-semibold t-upper">Bairro <span class="f-red">*</span></small>
                <div class="select form-disabled">
                    <select name="district" id="district" class="select-medio" required disabled>
                        <option value="" selected disabled>Selecione um bairro</option>
                        <?php
                        if ($districts) :
                            foreach ($districts as $district) :
                                echo "<option value='{$district->id}' " . ($district->id == $record->district ? 'selected' : null) . ">" . ($district->id == $record->district ? '&raquo; ' : null) . "{$district->name}</option>";
                            endforeach;
                        endif;
                        ?>
                    </select>
                </div>
            </label>

            <div class="box box100">
                <div class="box-full padding-total-normal radius-p box-white mb-30 mt-30" style="border: 1px solid seagreen;">
                    <h3 class="title-page-sec f-semibold f-black t-upper">Levantamento de dados do bairro:</h3>
                </div>
            </div>

            <label class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">O que é você no seu bairro? <span class="f-red">*</span></small>
                <div class="select form-disabled">
                    <select name="type_personal" class="select-medio" required disabled>
                        <option value="" selected disabled>Selecione uma opção</option>
                        <?php
                        foreach (getTypePersonal() as $k => $v) :
                            echo "<option value='{$k}' " . ($k == $record->type_personal ? 'selected' : null) . ">" . ($k == $record->type_personal ? '&raquo; ' : null) . "{$v}</option>";
                        endforeach;
                        ?>
                    </select>
                </div>
            </label>

            <div class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">QUAL O MEIO VOCÊ MAIS UTILIZA PARA SE INFORMAR?</small>
                <div class="flex-container flex-direction-column pl-20 mt-20">
                    <?php
                    $record->methods_comunication = Helper::arrayFromString($record->methods_comunication);
                    foreach (getMethodComunication() as $k => $v) :
                    ?>
                        <article class="mb-10">
                            <input type="checkbox" disabled <?= Helper::arraySetChecked($k, $record->methods_comunication) ?> value="<?= $k ?>" name="methods_comunication[]" id="check_1_<?= $k ?>">
                            <label for="check_1_<?= $k ?>"><?= $v ?></label>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">O QUE SEU BAIRRO MAIS PRECISA?</small>
                <div class="flex-container flex-direction-column pl-20 mt-20">
                    <?php
                    $record->district_need = Helper::arrayFromString($record->district_need);
                    foreach (getNeedDistrict() as $k => $v) :
                    ?>
                        <article class="mb-10">
                            <input type="checkbox" disabled <?= Helper::arraySetChecked($k, $record->district_need) ?> value="<?= $k ?>" name="district_need[]" id="check_2_<?= $k ?>">
                            <label for="check_2_<?= $k ?>"><?= $v ?></label>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">SANEAMENTO</small>
                <div class="flex-container flex-direction-column pl-20 mt-20">
                    <?php
                    $record->district_need_sanitation = Helper::arrayFromString($record->district_need_sanitation);
                    foreach (getNeedDistrictSanitation() as $k => $v) :
                    ?>
                        <article class="mb-10">
                            <input type="checkbox" disabled <?= Helper::arraySetChecked($k, $record->district_need_sanitation) ?> value="<?= $k ?>" name="district_need_sanitation[]" id="check_3_<?= $k ?>">
                            <label for="check_3_<?= $k ?>"><?= $v ?></label>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">ESTRADAS</small>
                <div class="flex-container flex-direction-column pl-20 mt-20">
                    <?php
                    $record->district_need_roads = Helper::arrayFromString($record->district_need_roads);
                    foreach (getNeedDistrictRoads() as $k => $v) :
                    ?>
                        <article class="mb-10">
                            <input type="checkbox" disabled <?= Helper::arraySetChecked($k, $record->district_need_roads) ?> value="<?= $k ?>" name="district_need_roads[]" id="check_4_<?= $k ?>">
                            <label for="check_4_<?= $k ?>"><?= $v ?></label>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">EDUCAÇÃO</small>
                <div class="flex-container flex-direction-column pl-20 mt-20">
                    <?php
                    $record->district_need_education = Helper::arrayFromString($record->district_need_education);
                    foreach (getNeedDistrictEducation() as $k => $v) :
                    ?>
                        <article class="mb-10">
                            <input type="checkbox" disabled <?= Helper::arraySetChecked($k, $record->district_need_education) ?> value="<?= $k ?>" name="district_need_education[]" id="check_5_<?= $k ?>">
                            <label for="check_5_<?= $k ?>"><?= $v ?></label>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">SAÚDE</small>
                <div class="flex-container flex-direction-column pl-20 mt-20">
                    <?php
                    $record->district_need_health = Helper::arrayFromString($record->district_need_health);
                    foreach (getNeedDistrictHealth() as $k => $v) :
                    ?>
                        <article class="mb-10">
                            <input type="checkbox" disabled <?= Helper::arraySetChecked($k, $record->district_need_health) ?> value="<?= $k ?>" name="district_need_health[]" id="check_6_<?= $k ?>">
                            <label for="check_6_<?= $k ?>"><?= $v ?></label>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">ESPORTE</small>
                <div class="flex-container flex-direction-column pl-20 mt-20">
                    <?php
                    $record->district_need_sports = Helper::arrayFromString($record->district_need_sports);
                    foreach (getNeedDistrictSports() as $k => $v) :
                    ?>
                        <article class="mb-10">
                            <input type="checkbox" disabled <?= Helper::arraySetChecked($k, $record->district_need_sports)?> value="<?= $k ?>" name="district_need_sports[]" id="check_7_<?= $k ?>">
                            <label for="check_7_<?= $k ?>"><?= $v ?></label>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">CULTURA</small>
                <div class="flex-container flex-direction-column pl-20 mt-20">
                    <?php
                    $record->district_need_culture = Helper::arrayFromString($record->district_need_culture);
                    foreach (getNeedDistrictCulture() as $k => $v) :
                    ?>
                        <article class="mb-10">
                            <input type="checkbox" disabled <?= Helper::arraySetChecked($k, $record->district_need_culture) ?> value="<?= $k ?>" name="district_need_culture[]" id="check_8_<?= $k ?>">
                            <label for="check_8_<?= $k ?>"><?= $v ?></label>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">MEIO AMBIENTE</small>
                <div class="flex-container flex-direction-column pl-20 mt-20">
                    <?php
                    $record->district_need_environment = Helper::arrayFromString($record->district_need_environment);
                    foreach (getNeedDistrictEnvironment() as $k => $v) :
                    ?>
                        <article class="mb-10">
                            <input type="checkbox" disabled <?= Helper::arraySetChecked($k, $record->district_need_environment) ?> value="<?= $k ?>" name="district_need_environment[]" id="check_9_<?= $k ?>">
                            <label for="check_9_<?= $k ?>"><?= $v ?></label>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">SEGURANÇA</small>
                <div class="flex-container flex-direction-column pl-20 mt-20">
                    <?php
                    $record->district_need_security = Helper::arrayFromString($record->district_need_security);
                    foreach (getNeedDistrictSecurity() as $k => $v) :
                    ?>
                        <article class="mb-10">
                            <input type="checkbox" disabled <?= Helper::arraySetChecked($k, $record->district_need_security) ?> value="<?= $k ?>" name="district_need_security[]" id="check_10_<?= $k ?>">
                            <label for="check_10_<?= $k ?>"><?= $v ?></label>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">HABITAÇÃO</small>
                <div class="flex-container flex-direction-column pl-20 mt-20">
                    <?php
                    $record->district_need_habitation = Helper::arrayFromString($record->district_need_habitation);
                    foreach (getNeedDistrictHabitation() as $k => $v) :
                    ?>
                        <article class="mb-10">
                            <input type="checkbox" disabled <?= Helper::arraySetChecked($k, $record->district_need_habitation) ?> value="<?= $k ?>" name="district_need_habitation[]" id="check_11_<?= $k ?>">
                            <label for="check_11_<?= $k ?>"><?= $v ?></label>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">DESENVOLVIMENTO ECONÔMICO</small>
                <div class="flex-container flex-direction-column pl-20 mt-20">
                    <?php
                    $record->district_need_economy = Helper::arrayFromString($record->district_need_economy);
                    foreach (getNeedDistrictEconomy() as $k => $v) :
                    ?>
                        <article class="mb-10">
                            <input type="checkbox" disabled <?= Helper::arraySetChecked($k, $record->district_need_economy) ?> value="<?= $k ?>" name="district_need_economy[]" id="check_12_<?= $k ?>">
                            <label for="check_12_<?= $k ?>"><?= $v ?></label>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">TRANSPORTE COLETIVO</small>
                <div class="flex-container flex-direction-column pl-20 mt-20">
                    <?php
                    $record->district_need_transport = Helper::arrayFromString($record->district_need_transport);
                    foreach (getNeedDistrictTransport() as $k => $v) :
                    ?>
                        <article class="mb-10">
                            <input type="checkbox" disabled <?= Helper::arraySetChecked($k, $record->district_need_transport)?> value="<?= $k ?>" name="district_need_transport[]" id="check_13_<?= $k ?>">
                            <label for="check_13_<?= $k ?>"><?= $v ?></label>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">MELHORIAS NA URBANIZAÇÃO</small>
                <div class="flex-container flex-direction-column pl-20 mt-20">
                    <?php
                    $record->district_need_urban = Helper::arrayFromString($record->district_need_urban);
                    foreach (getNeedDistrictUrban() as $k => $v) :
                    ?>
                        <article class="mb-10">
                            <input type="checkbox" disabled <?= Helper::arraySetChecked($k, $record->district_need_urban) ?> value="<?= $k ?>" name="district_need_urban[]" id="check_14_<?= $k ?>">
                            <label for="check_14_<?= $k ?>"><?= $v ?></label>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="box box100 flex-container flex-itens-center flex-justify-space-between">
                <p style="font-size: 12px;" class="f-black f-light t-upper"><span class="f-red">*</span> Campos obrigatórios</p>
                <button class="btn btn-medio btn-green radius-g" id="buttonUpdate" style="display: none;">
                    <i class="icon-check-alt mr-5"></i> Atualizar cadastro
                </button>
            </div>
    </form>
</div>

<div class="trigger-box"></div>