<?php
    
    use Source\Support\Helper;
    use CoffeeCode\Cropper\Cropper;
    
    $c = new Cropper("cache");
    
    $v->layout('inc/dashboard');
?>

<div class="box-full mb-50">
    <header class="pb-60">
        <h1 class="title-page f-black f-semibold mb-10">
            <i class="icon-comment-alt2-stroke mr-10"></i> Editar Post
        </h1>
        <div class="nav float_l">
            <ul>
                <li class="t-upper">
                    <a href="<?= HOME ?>"><?= COMPANY_NAME ?></a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li class="t-upper">
                    <a href="<?= HOME ?>/admin">Dashboard</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li class="t-upper">
                    <a href="<?= HOME ?>/admin/posts">Posts</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li class="t-upper">
                    <a href="<?= HOME ?>/admin/posts/update/<?= $post->id ?>">Editar Post</a>
                </li>
            </ul>
        </div>

        <nav class="options-default j_list">
            <a href="<?= HOME ?>/admin/posts" class="btn btn-icon-medio btn-blue radius-g"><i class="icon-arrow-left2"></i></a>
            <a rel="<?= $post->id ?>" id="delete" class="btn btn-icon-medio btn-red radius-g j_delete"><i class="icon-trash"></i></a>
        </nav>
    </header>
</div>

<div class="box-full mb-20">
    <form action="" method="post" class="j_formajax" enctype="multipart/form-data">
        <input type="hidden" name="callback" value="manager" class="noclear">
        <input type="hidden" name="id" value="<?= $post->id ?>" class="noclear">

        <div class="box box60">
            <label class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">Título do post</small>
                <input type="text" name="title" required class="form input-form-larg" placeholder="Título do post" value="<?= $post->title ?>">
            </label>

            <label class="box box40">
                <small class="small-titulo-2 f-silver f-semibold t-upper">Cód. do vídeo</small>
                <input type="text" name="video" class="form input-form-larg" placeholder="Cód. do vídeo" value="<?= $post->video ?>">
            </label>

            <label class="box box100 mt-20">
                <div class="box-full padding-total-low radius-m box-white">
                    <textarea name="description" id="elm1"><?= $post->description ?></textarea>
                </div>
            </label>
        </div>

        <div class="box box40">
            <label class="box box100 mt-15" style="cursor:pointer;">
                <img id="blah" src="#" class="mb-20 radius-m" style="display: none"/>
                <?= Helper::image($c->make($post->cover, 1150, 650), $post->title, "img radius-m mb-20 j_cover") ?>
                <small class="small-titulo-2 f-silver f-semibold t-upper">Foto de capa</small>
                <input type="file" name="cover" class="form input-form-medio file box-white" onchange="readURL(this);">
                <input type="hidden" name="image_current" value="<?= $post->cover ?>"/>
            </label>

            <label class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">Tipo</small>
                <div class="select">
                    <select name="type" required class="select-medio">
                        <option value="<?= $post->type ?>" selected>&raquo; <?= getTypePost($post->type) ?></option>
                        <?php foreach (getTypePost() as $k => $v): ?>
                            <option value="<?= $k ?>"><?= $v ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </label>

            <label class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">Categoria</small>
                <div class="select">
                    <select name="category" required class="select-medio">
                        <option value="<?= $post->category ?>" selected>&raquo; <?= $post->getCategory()->title ?></option>
                        <?php foreach ($categories as $ca): ?>
                            <option value="<?= $ca->id ?>"><?= $ca->title ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </label>

            <div class="box box100">
                <button class="btn btn-medio btn-green radius-g float_r">
                    <i class="icon-check-alt mr-5"></i> Atualizar
                </button>

                <div class="float_r mr-20 mt-15">
                    <input type="checkbox" value="1" name="status" <?= ($post->status == 1 ? 'checked' : null) ?> id="check">
                    <label for="check">Publicar</label>
                </div>
            </div>
        </div>
    </form>
</div>

<div class="box-full">
    <div class="box box100" id="gbfoco">
        <div class="box-full box-white padding-total-normal radius-m">
            <h1 class="title-page f-black f-thim">
                <i class="fa fa-photo fa-r1"></i> Galeria de Imagens
            </h1>
            <form action="" method="post" class="j_formajax_gb" enctype="multipart/form-data">
                <input type="hidden" class="noclear" name="callback" value="gb">
                <input type="hidden" class="noclear" name="post" value="<?= $post->id ?>">
                <nav class="box-options float_r">
                    <button type="submit" name="btnGal" class="btn btn-medio btn-green radius-g">
                        <i class="fa fa-upload fa-r1"></i> Enviar Imagens
                    </button>
                </nav>

                <!-- BAR LOADING -->
                <?php $percent = 90; ?>
                <div class="bar-loading box100 float_l">
                    <div class="bar box-orange f-white f-bold t-center">0%</div>
                </div>
                <!-- BAR LOADING -->

                <div class="box-diagram1" style="margin-top: 20px">
                    <small class="small-titulo-2 f-silver f-semibold t-upper">Upload de imagens</small>
                    <input type="file" name="cover[]" required multiple class="form input-form-larg file box-silver">
                </div>
            </form>
            <div class="line" style="margin-top: 15px"></div>
            <div class="clear"></div>

            <div class="content-gal float_l box100 j_list">
                <?php
                    $i = 0;
                    if ($gb):
                        foreach ($gb as $g):
                            $i++;
                            ?>
                            <article class="float_l" id="<?= $g->id ?>">
                                <a href="<?= HOME ?>/<?= $g->cover ?>" rel="shadowbox[album]"><?= Helper::image($c->make($g->cover, 1150, 800), "Images {$i}", "img j_cover") ?></a>
                                <header class="transition">
                                    <a class="btn btn-icon-low btn-red round j_delete" id="gbdelete" rel="<?= $g->id ?>"><i class="fa fa-trash-o"></i></a>
                                </header>
                            </article>
                        <?php
                        endforeach;
                    endif;
                ?>
            </div>
        </div>
    </div>
</div>

