<?php

namespace Source\Models;

use CoffeeCode\DataLayer\DataLayer;
use Exception;
use Source\Support\Helper;

class Record extends DataLayer
{
    public function __construct()
    {
        parent::__construct("records", [
            "name",
            "lastname",
            "phone",
            "genre",
            "birth",
            "user",
            "state",
            "city",
            "district"
        ]);
    }

    public function save(): bool
    {
        $this->birth = Helper::date($this->birth);

        if (!parent::save()) :
            return false;
        endif;

        return true;
    }

    public function getUser()
    {
        return (new User())->findById($this->user);
    }

    public function getState()
    {
        return (new State())->find("uf = :uf", "uf={$this->state}")->fetch();
    }

    public function getCity()
    {
        return (new City())->findById($this->city);
    }

    public function getDistrict()
    {
        return (new District())->findById($this->district);
    }

    protected function validadeEmail(): bool
    {
        if (!Helper::email($this->email)) :
            $this->fail = new Exception("O e-mail que você informou não possui um formato válido.");
            return false;
        endif;

        // $where = ($this->id ? "AND id != {$this->id}" : null);
        // $findRecordByEmail = (new Record())->find("email = :email {$where}", "email={$this->email}")->count();

        // if ($findRecordByEmail) :
        //     $this->fail = new Exception("O e-mail que você informou já está cadastrado.");
        //     return false;
        // endif;

        return true;
    }
}
