<?php

namespace Source\Models;

use CoffeeCode\DataLayer\DataLayer;
use Source\Models\Category;

class Post extends DataLayer
{
    public function __construct()
    {
        parent::__construct("posts", [
            "title",
            "uri"
        ]);
    }

    public function getParent()
    {
        return (new Category())->findById($this->parent);
    }

    public function getCategory()
    {
        return (new Category())->findById($this->category);
    }

    public function getGallery()
    {
        return (new GbPost())->find("post = :p", "p={$this->id}")
        ->order("created_at DESC")
        ->fetch(true);
    }
}
