<script>
    const ctx1 = document.getElementById('myChart').getContext('2d');
    const ctx2 = document.getElementById('myChart2').getContext('2d');
    const ctx3 = document.getElementById('myChart3').getContext('2d');
    const ctx4 = document.getElementById('myChart4').getContext('2d');

    let colors = ["#ff6384", "#5959e6", "#2babab", "#8c4d15", "#8bc34a", "#607d8b", "#009688"];

    // Global Options
    Chart.defaults.global.defaultFontFamily = 'Lato';
    Chart.defaults.global.defaultFontSize = 18;
    Chart.defaults.global.defaultFontColor = '#777';

    const myChart = new Chart(ctx1, {
        type: 'line',
        data: {
            labels: [
                <?php
                foreach (getMonth() as $k => $month) :
                    if ($k != '00') :
                ?> '<?= substr(strtoupper($month), 0, 3) ?>',
                <?php
                    endif;
                endforeach;
                ?>
            ],
            datasets: [
                <?php foreach (getNeedDistrict() as $k => $v) : ?> {
                        label: '<?= $v ?>',
                        data: [
                            <?php
                            foreach (getMonth() as $km => $month) :
                                if ($km != '00') :
                                    echo $graphNeedDistrict[$km][$k] . ",";
                                endif;
                            endforeach;
                            ?>
                        ],
                        backgroundColor: ['rgba(0,0,0,0)'],
                        borderWidth: 3,
                        borderColor: '#' + Math.floor(Math.random() * 16777215).toString(16),
                    },
                <?php endforeach; ?>
            ]
        },
        options: {
            title: {
                display: false
            },
            legend: {
                display: true,
            },
            scales: {
                yAxes: [{
                    ticks: {
                        fontSize: 12,
                        beginAtZero: true,
                        userCallback: function(label) {
                            if (Math.floor(label) === label) {
                                return label;
                            }
                        },
                    },
                    gridLines: {
                        color: "rgba(0,0,0,.05)",
                        drawBorder: false,
                    }
                }],
                xAxes: [{
                    ticks: {
                        fontSize: 11
                    },
                    gridLines: {
                        display: false,
                        zeroLineColor: 'transparent'
                    },
                }]
            },
            plugins: {
                datalabels: {
                    display: false
                }
            }
        }
    });

    const myChart2 = new Chart(ctx2, {
        type: 'doughnut',
        data: {
            labels: [
                <?php foreach (getMethodComunication() as $k => $v) : ?> '<?= $v ?>',
                <?php endforeach; ?>
            ],
            datasets: [{
                label: '# of Votes',
                data: [
                    <?php
                    foreach (getMethodComunication() as $km => $v) :
                        echo $graphMethods[$km] . ',';
                    endforeach;
                    ?>
                ],
                backgroundColor: [
                    <?php foreach (getMethodComunication() as $k => $v) : ?> '#' + Math.floor(Math.random() * 16777215).toString(16), <?php endforeach; ?>
                ],
                borderColor: [
                    <?php foreach (getMethodComunication() as $k => $v) : ?> 'rgba(54, 162, 235, 0)', <?php endforeach; ?>

                ],
                borderWidth: 1
            }]
        },
        options: {
            title: {
                display: false
            },
            legend: {
                display: false
            },
            plugins: {
                datalabels: {
                    fontWeight: 'bold',
                    color: '#ffffff',
                    textShadowBlur: 10,
                    textShadowColor: '#222222',
                    font: {
                        size: 12
                    },
                    formatter: function(value, context) {
                        return context.chart.data.labels[context.dataIndex] + '\n' + value;
                    }
                },
            }
        }
    });

    const myChart3 = new Chart(ctx3, {
        type: 'doughnut',
        data: {
            labels: [
                <?php foreach (getTypePersonal() as $k => $v) : ?> '<?= $v ?>',
                <?php endforeach; ?>
            ],
            datasets: [{
                label: '# of Votes',
                data: [
                    <?php
                    foreach (getTypePersonal() as $km => $v) :
                        echo $graphTypePersonal[$km] . ',';
                    endforeach;
                    ?>
                ],
                backgroundColor: [
                    <?php foreach (getTypePersonal() as $k => $v) : ?> '#' + Math.floor(Math.random() * 16777215).toString(16), <?php endforeach; ?>
                ],
                borderColor: [
                    <?php foreach (getTypePersonal() as $k => $v) : ?> 'rgba(54, 162, 235, 0)', <?php endforeach; ?>

                ],
                borderWidth: 1
            }]
        },
        options: {
            title: {
                display: false
            },
            legend: {
                display: false
            },
            plugins: {
                datalabels: {
                    fontWeight: 'bold',
                    color: '#ffffff',
                    textShadowBlur: 10,
                    textShadowColor: '#222222',
                    font: {
                        size: 12
                    },
                    formatter: function(value, context) {
                        return context.chart.data.labels[context.dataIndex] + '\n' + value;
                    }
                },
            }
        }
    });

    const myChart4 = new Chart(ctx4, {
        type: 'doughnut',
        data: {
            labels: [
                <?php foreach (getGenre() as $k => $v) : ?> '<?= $v ?>',
                <?php endforeach; ?>
            ],
            datasets: [{
                label: '# of Votes',
                data: [
                    <?php
                    foreach (getGenre() as $km => $v) :
                        echo $graphGenre[$km] . ',';
                    endforeach;
                    ?>
                ],
                backgroundColor: [
                    <?php foreach (getGenre() as $k => $v) : ?> '#' + Math.floor(Math.random() * 16777215).toString(16), <?php endforeach; ?>
                ],
                borderColor: [
                    <?php foreach (getGenre() as $k => $v) : ?> 'rgba(54, 162, 235, 0)', <?php endforeach; ?>

                ],
                borderWidth: 1
            }]
        },
        options: {
            title: {
                display: false
            },
            legend: {
                display: false
            },
            plugins: {
                datalabels: {
                    fontWeight: 'bold',
                    color: '#ffffff',
                    textShadowBlur: 10,
                    textShadowColor: '#222222',
                    font: {
                        size: 12
                    },
                    formatter: function(value, context) {
                        return context.chart.data.labels[context.dataIndex] + '\n' + value;
                    }
                },
            }
        }
    });
</script>